/////////////////////////////////////////////////////////////////////////
#include <18F45K80.h>

#include "pin_defines.h"

//#fuses NOWDT,NOPROTECT,NODEBUG, NOXINST, NOBROWNOUT
#Fuses NOPLLEN,NOPUT,NOIESO,NOFCMEN,NOBROWNOUT,NOWDT,NOEBTRB,NOEBTR,XT

#use delay(clock=8000000) //8MHz

void main() {
   unsigned int8 i=1;
   unsigned int16 debounce=0;
   
   output_high( BUZZER );
   delay_ms(500);
   output_low( BUZZER );  

   output_low( LED1 );
   output_low( LED2 );
   output_low( LED3 );
   output_low( LED4 );
//   output_low( LED5 );  //pin A4 does not exist on this PIC. Ooops...
   output_low( LED6 );
   output_low( LED7 );

   output_low( OUT1 );
   output_low( OUT2 );
   output_low( OUT3 );
   output_low( OUT4 );
   output_low( OUT5 );
   output_low( OUT6 );
   output_low( OUT7 );

   output_low( MISC_LED );
   output_low( CAN_TX );
   output_low( CAN_RX );
   output_low( IN2 );  //status-led is incorrectly wired to this pin

   do {
     if (!input(BUTTON)) { //button pressed
       debounce++;
     } else {
       debounce=0;
     }
     delay_ms(1);
     if (debounce > 100) {
       debounce=0;
       switch (i) {
         case 1:
            output_toggle( LED1 );
            break;
         case 2:
            output_toggle( LED2 );
            break;
         case 3:
            output_toggle( LED3 );
            break;
         case 4:
            output_toggle( LED4 );
            break;
         case 5:
//            output_toggle( LED5 );  //PIN R4 does not exist on this pic. oops...
            break;
         case 6:
            output_toggle( LED6 );
            break;
         case 7:
            output_toggle( LED7 );
            break;
         case 8:
            output_toggle( OUT1 );
            break;
         case 9:
            output_toggle( OUT2 );
            break;
         case 10:
            output_toggle( OUT3 );
            break;
         case 11:
            output_toggle( OUT4 );
            break;
         case 12:
            output_toggle( OUT5 );
            break;
         case 13:
            output_toggle( OUT6 );
            break;
         case 14:
            output_toggle( OUT7 );
            break;
         case 15:
            output_toggle( MISC_LED );
            break;
         case 16:
            output_toggle( CAN_TX );
            break;
         case 17:
            output_toggle( CAN_RX );
            break;
       }
       i++;
       if ( i>17)
         i = 1;
     }

   } while (TRUE);
}
